<?php
include("../Tollsk/Connectk.php");


// Retrieve and sanitize inputs
$home_message = mysqli_real_escape_string($con, $_GET['home_message']);

// Prepare a statement to check if any record exists
$sql = "SELECT COUNT(*) FROM tols";
$stmt = mysqli_prepare($con, $sql);
if ($stmt === false) {
    die('Prepare failed: ' . htmlspecialchars(mysqli_error($con)));
}

mysqli_stmt_execute($stmt);
mysqli_stmt_bind_result($stmt, $rowcount);
mysqli_stmt_fetch($stmt);
mysqli_stmt_close($stmt);

if ($rowcount > 0) {
    // Update the record if it exists
    $sql2 = "UPDATE tols SET home_message = ? WHERE id = 1";
    $stmt2 = mysqli_prepare($con, $sql2);
    if ($stmt2 === false) {
        die('Prepare failed: ' . htmlspecialchars(mysqli_error($con)));
    }

    mysqli_stmt_bind_param($stmt2, "s", $home_message);
    $result = mysqli_stmt_execute($stmt2);
    mysqli_stmt_close($stmt2);

    if ($result) {
        echo "হোম মেসেজ সেট করা হলো";
    } else {
        echo "হয়নি! আবার ট্রাই করুন";
        echo "Error: " . htmlspecialchars(mysqli_error($con));
    }
} else {
    echo "No records found!";
}

// Close connection
mysqli_close($con);
?>
