<?php 
include("../Tollsk/Connectk.php");

// Retrieve and sanitize inputs
$msg = $_GET['msg'];
$phone = $_GET['phone'];

// Process the message
$msg_array = explode(" ", str_replace(".00", " JPAY", $msg));

// Extract transaction ID and amount
$tnxid_index = array_search("TXNID", $msg_array);
$tnxid = $tnxid_index !== false ? $msg_array[$tnxid_index + 1] : '';
$amount_index = array_search("JPAY", $msg_array);
$amount = $amount_index !== false ? $msg_array[$amount_index - 1] : '';

// Check if tnxid already exists
$check_sql = "SELECT COUNT(*) FROM add_money WHERE tnxid = ?";
$stmt = mysqli_prepare($con, $check_sql);
mysqli_stmt_bind_param($stmt, "s", $tnxid);
mysqli_stmt_execute($stmt);
mysqli_stmt_bind_result($stmt, $count);
mysqli_stmt_fetch($stmt);
mysqli_stmt_close($stmt);

// Insert if not exists
if ($count == 0) {
    $insert_sql = "INSERT INTO add_money (sms_body, tnx_op, tnxid, amount) VALUES (?, ?, ?, ?)";
    $stmt = mysqli_prepare($con, $insert_sql);
    mysqli_stmt_bind_param($stmt, "ssss", $msg, $phone, $tnxid, $amount);
    mysqli_stmt_execute($stmt);
    mysqli_stmt_close($stmt);
    echo "Payment Successful";
} else {
    echo "Transaction ID already exists.";
}

// Close connection
mysqli_close($con);
?>