<?php
include("../../Tollsk/Connectk.php");

if ($con->connect_error) {
    die("Connection failed: " . $con->connect_error);
}

// POST ডেটা থেকে সিম নম্বরগুলি গ্রহণ
$sim_one = $_POST['sim_one']; 
$sim_two = $_POST['sim_two'];

// SQL কুয়েরি স্টেটমেন্ট প্রস্তুত করা (প্রস্তুত করা স্টেটমেন্ট ব্যবহার করা হয়েছে SQL ইনজেকশন থেকে রক্ষা পেতে)
$sql = $con->prepare("SELECT * FROM recharge_history WHERE status = 'Pending' AND (operator_k = ? OR operator_k = ?) ORDER BY id ASC LIMIT 1");

// চেক করতে হবে prepare() সফলভাবে কাজ করছে কিনা
if ($sql === false) {
    die('MySQL prepare error: ' . $con->error);
}

// প্রস্তুত করা স্টেটমেন্টে প্যারামিটারগুলি বেঁধে দেয়া
$sql->bind_param("ss", $sim_one, $sim_two);  // 'ss' মানে দুটি স্ট্রিং প্যারামিটার

// কুয়েরি এক্সিকিউট করা
$sql->execute();
$result = $sql->get_result();

if ($result->num_rows > 0) {
    $row = $result->fetch_assoc();

    // JSON রেসপন্স তৈরি করা
    $response = array(
        'operator_k' => $row['operator_k'],
         'mobile' => $row['mobile'],
        'amount' => $row['amount'],
        'status' => $row['status']
    );

    // স্ট্যাটাস আপডেট
    $update_sql = $con->prepare("UPDATE recharge_history SET status = 'processing' WHERE id = ?");
    if ($update_sql === false) {
        die('MySQL prepare error: ' . $con->error);
    }

    $update_sql->bind_param("i", $row['id']);  // 'i' মানে ইনটিজার প্যারামিটার

    if ($update_sql->execute()) {
        // JSON রেসপন্স পাঠানো
        echo json_encode($response);
    } else {
        echo json_encode(array('error' => 'Failed to update status.'));
    }
} else {
    echo json_encode(array('error' => 'No pending records found for the given SIMs.'));
}

$con->close();
?>
